---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-kubeadm config

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/config.go` - configコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのサブコマンド（print, migrate, validate, images） | E-01 行71-74 AddCommand | ○ |
| C-02 | print系に4つのサブコマンド（init/join/reset/upgrade-defaults） | E-01 行88-92 | ○ |
| C-03 | --component-configsはinit-defaultsのみで使用可能 | E-01 行135-138 | ○ |
| C-04 | migrate時に--old-configが必須 | E-01 行280-282 | ○ |
| C-05 | validate時に--configが必須 | E-01 行330-332 | ○ |
| C-06 | validate成功時に"ok"を出力 | E-01 行342 | ○ |
| C-07 | images listとpullの2サブコマンド | E-01 行361-363 | ○ |
| C-08 | images pullでcontainerRuntime.PullImage()を呼ぶ | E-01 行406 PullImage | ○ |
| C-09 | legacyKindToGroupMapの定義 | E-01 行176-179 | ○ |
| C-10 | --allow-experimentalフラグ（migrate, validate） | E-01 行307, 350 | ○ |
| C-11 | --allow-deprecatedフラグ（validate） | E-01 行349 | ○ |
| C-12 | サポートAPIバージョンはv1beta4 | E-01 行278 SchemeGroupVersion | ○ |
| C-13 | 関連機能118-クラスター初期化が補助機能 | E-03 画面No49 | ○ |
| C-14 | print出力は---区切りで結合 | E-01 行157 YAMLDocumentSeparator | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから主要な処理フローが明確に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] configutil.MigrateOldConfigの変換ロジックを確認
- [ ] images.GetControlPlaneImages()の返すイメージ一覧を確認
- [ ] デフォルトイメージリポジトリが正確か確認
